/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventoryView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;

public class InventoryViewHelper {
    private static transient Player containerOwner;

    public static void captureContainerOwner(Player entity) {
        containerOwner = entity;
    }

    public static Player getContainerOwner() {
        return containerOwner;
    }

    public static void resetContainerOwner() {
        containerOwner = null;
    }

    public static InventoryView createInvView(AbstractContainerMenu container) {
        CraftInventory viewing = InventoryViewHelper.createInv(containerOwner, container);
        return new CraftInventoryView(containerOwner.getBukkitEntity(), viewing, container);
    }

    public static CraftInventory createInv(Player containerOwner, AbstractContainerMenu container) {
        return new CraftInventory(new ContainerInvWrapper(container, containerOwner));
    }

    private static class ContainerInvWrapper
    implements Container {
        private final AbstractContainerMenu container;
        private InventoryHolder owner;
        private final List<HumanEntity> viewers = new ArrayList<HumanEntity>();

        public ContainerInvWrapper(AbstractContainerMenu container, Player owner) {
            this.container = container;
            this.owner = owner.getBukkitEntity();
        }

        public int m_6643_() {
            return this.container.f_38841_.size();
        }

        public boolean m_7983_() {
            for (Slot slot : this.container.f_38839_) {
                if (slot.m_7993_().m_41619_()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ItemStack m_8020_(int index) {
            if (index >= this.m_6643_()) {
                return ItemStack.f_41583_;
            }
            return this.container.m_38853_(index).m_7993_();
        }

        @NotNull
        public ItemStack m_7407_(int index, int count) {
            if (index >= this.m_6643_()) {
                return ItemStack.f_41583_;
            }
            return this.container.m_38853_(index).m_6201_(count);
        }

        @NotNull
        public ItemStack m_8016_(int index) {
            if (index >= this.m_6643_()) {
                return ItemStack.f_41583_;
            }
            return this.container.m_38853_(index).m_6201_(Integer.MAX_VALUE);
        }

        public void m_6836_(int index, @NotNull ItemStack stack) {
            if (index >= this.m_6643_()) {
                return;
            }
            this.container.m_38853_(index).m_5852_(stack);
        }

        public int m_6893_() {
            if (this.m_6643_() <= 0) {
                return 0;
            }
            return this.container.m_38853_(0).m_6641_();
        }

        public void m_6596_() {
        }

        public boolean m_6542_(@NotNull Player player) {
            return this.container.m_6875_(player);
        }

        public void m_6211_() {
            for (Slot slot : this.container.f_38839_) {
                slot.m_6201_(Integer.MAX_VALUE);
            }
        }

        public List<ItemStack> getContents() {
            this.container.m_38946_();
            return this.container.f_38841_.subList(0, this.m_6643_());
        }

        public void onOpen(CraftHumanEntity who) {
            this.viewers.add(who);
        }

        public void onClose(CraftHumanEntity who) {
            this.viewers.remove(who);
        }

        public List<HumanEntity> getViewers() {
            return this.viewers;
        }

        public InventoryHolder getOwner() {
            return this.owner;
        }

        public void setMaxStackSize(int size) {
        }

        public Location getLocation() {
            return null;
        }

        public Recipe<?> getCurrentRecipe() {
            return null;
        }
    }
}

